<?php
// actions/upload_imagen_simple.php

// Escribir log desde el inicio
$log_file = dirname(__FILE__) . '/upload_log.txt';
$log = date('Y-m-d H:i:s') . " - Inicio\n";
file_put_contents($log_file, $log, FILE_APPEND);

// Capturar cualquier error
function error_handler($errno, $errstr, $errfile, $errline) {
    global $log_file;
    $msg = "Error: [$errno] $errstr en $errfile:$errline\n";
    file_put_contents($log_file, $msg, FILE_APPEND);
    
    // Mostrar página de error
    echo '<html><body>';
    echo '<h1>Error en Upload</h1>';
    echo '<p>' . htmlspecialchars($msg) . '</p>';
    echo '<a href="../index.php?page=productos_imperfectos">Volver</a>';
    echo '</body></html>';
    exit;
}
set_error_handler('error_handler');

try {
    // Log de datos recibidos
    $log .= "POST: " . print_r($_POST, true) . "\n";
    $log .= "FILES: " . print_r($_FILES, true) . "\n";
    file_put_contents($log_file, $log, FILE_APPEND);
    
    // Cargar configuración
    require_once '/home/crusardi/config_crusardi/database.php';
    
    // Iniciar sesión
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Procesar upload
    $codigo = $_POST['codigo_unico'] ?? '';
    if (empty($codigo)) {
        throw new Exception("No se proporcionó código único");
    }
    
    // Buscar archivo
    $archivo_num = 0;
    for ($i = 1; $i <= 5; $i++) {
        if (isset($_FILES["foto_$i"]) && $_FILES["foto_$i"]['error'] === 0) {
            $archivo_num = $i;
            break;
        }
    }
    
    if ($archivo_num === 0) {
        throw new Exception("No se recibió ningún archivo");
    }
    
    // Conectar FTP
    $conn = ftp_connect(FTP_HOST);
    if (!$conn) {
        throw new Exception("No se pudo conectar a FTP");
    }
    
    if (!ftp_login($conn, FTP_USER, FTP_PASS)) {
        throw new Exception("Login FTP falló");
    }
    
    ftp_pasv($conn, true);
    
    // Crear directorio y subir
    $dir = 'N ' . $codigo;
    @ftp_chdir($conn, '/boconcept/SALE2019/');
    @ftp_mkdir($conn, $dir);
    
    $remote = '/boconcept/SALE2019/' . $dir . '/' . $archivo_num . '.jpg';
    
    if (ftp_put($conn, $remote, $_FILES["foto_$archivo_num"]['tmp_name'], FTP_BINARY)) {
        $_SESSION['upload_success'] = "Foto $archivo_num subida correctamente";
        file_put_contents($log_file, "Éxito: archivo subido a $remote\n", FILE_APPEND);
    } else {
        throw new Exception("Error al subir archivo");
    }
    
    ftp_close($conn);
    
} catch (Exception $e) {
    $_SESSION['upload_error'] = $e->getMessage();
    file_put_contents($log_file, "Error: " . $e->getMessage() . "\n", FILE_APPEND);
}

// Redirigir
header('Location: ../../index.php?page=upload_foto_imperfectos');
exit;
?>