<?php
/**
 * Script de monitoreo del catálogo público
 */
require_once "config.php";

$config_file = __DIR__ . "/logs/catalogo_config.json";
$config = json_decode(file_get_contents($config_file), true);

echo "=== MONITOR CATÁLOGO PÚBLICO ===\n";
echo "Estado: " . ($config["status"] ?? "Desconocido") . "\n";
echo "Última actualización: " . ($config["last_update"] ?? "Nunca") . "\n";
echo "Versión: " . ($config["version"] ?? "Desconocida") . "\n";

// Verificar accesibilidad
$catalogo_url = "https://stock.crusardi.net/catalogo_publico/";
$response = @file_get_contents($catalogo_url, false, stream_context_create(["http" => ["timeout" => 10]]));

if ($response !== false) {
    echo "Catálogo: ✓ Accesible\n";
} else {
    echo "Catálogo: ✗ No accesible\n";
}

// Verificar logs recientes
$log_file = __DIR__ . "/logs/auto_update.log";
if (file_exists($log_file)) {
    $last_log = file_get_contents($log_file);
    $lines = explode("\n", $last_log);
    $last_line = end($lines);
    echo "Último log: " . $last_line . "\n";
} else {
    echo "Último log: No disponible\n";
}
?>