<?php
// pages/actions/upload_image.php

require_once '/home/crusardi/config_crusardi/database.php';

// Iniciar sesión para poder guardar mensajes de éxito/error
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

try {
    $referencia = $_POST['referencia'] ?? null;
    if (!$referencia) {
        throw new Exception("No se proporcionó una referencia de producto.");
    }

    if (!isset($_FILES['product_image']) || $_FILES['product_image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception("No se recibió ningún archivo o hubo un error en la subida.");
    }

    $file_tmp_path = $_FILES['product_image']['tmp_name'];
    $file_name = $referencia . '.jpg'; // Forzar la extensión a .jpg para estandarizar
    $remote_path = '/boconcept/STOCKCOMERCIAL/' . $file_name;

    // 1. Conectar al servidor FTP
    $conn_id = ftp_connect(FTP_HOST);
    if (!$conn_id) {
        throw new Exception("No se pudo conectar al servidor FTP: " . FTP_HOST);
    }

    // 2. Iniciar sesión con las credenciales
    $login_result = ftp_login($conn_id, FTP_USER, FTP_PASS);
    if (!$login_result) {
        ftp_close($conn_id);
        throw new Exception("Las credenciales FTP son incorrectas.");
    }
    
    // Activar modo pasivo (muy importante para evitar problemas con firewalls)
    ftp_pasv($conn_id, true);

    // 3. Subir el archivo
    if (ftp_put($conn_id, $remote_path, $file_tmp_path, FTP_BINARY)) {
        // 4. Si la subida es exitosa, actualizar la base de datos
        $image_url = 'https://' . FTP_HOST . $remote_path;
        
        $check_stmt = $pdo->prepare("SELECT COUNT(*) FROM references_data WHERE referencia = ?");
        $check_stmt->execute([$referencia]);
        
        if ($check_stmt->fetchColumn() > 0) {
            // La referencia ya existe, la actualizamos
            $update_stmt = $pdo->prepare("UPDATE references_data SET url_imagen = ? WHERE referencia = ?");
            $update_stmt->execute([$image_url, $referencia]);
        } else {
            // La referencia no existe en la tabla de datos, creamos un nuevo registro
            $insert_stmt = $pdo->prepare("INSERT INTO references_data (referencia, url_imagen) VALUES (?, ?)");
            $insert_stmt->execute([$referencia, $image_url]);
        }

        $_SESSION['upload_success'] = "Imagen para '" . htmlspecialchars($referencia) . "' subida con éxito.";
        // Limpiar la caché del catálogo público para que el cambio se refleje
        @unlink(__DIR__ . '/../../cache/public_catalog_data.json');

    } else {
        throw new Exception("Hubo un problema al subir el archivo al FTP. Verifica los permisos de la carpeta de destino.");
    }

    // Cerrar la conexión FTP
    ftp_close($conn_id);

} catch (Exception $e) {
    $_SESSION['upload_error'] = "Error: " . $e->getMessage();
}

// Redirigir siempre de vuelta a la página de stock calculado
header('Location: ../../index.php?page=stock_calculado');
exit;