# Catálogo Público BoConcept Crusardi

Sistema de catálogo público que se actualiza automáticamente cada 6 horas con los datos de stock de BoConcept Crusardi.

## 🚀 Características

- **Actualización automática** cada 6 horas
- **Diseño responsivo** al estilo BoConcept Global
- **Filtros avanzados** por tipo, precio, categoría
- **Búsqueda en tiempo real**
- **Integración con WhatsApp** para consultas
- **SEO optimizado** para motores de búsqueda
- **Monitoreo automático** de salud del sistema

## 📁 Estructura de Archivos

```
catalogo_publico/
├── index.php              # Catálogo público principal
├── actualizar.php         # Script de actualización automática
├── cron.php              # Configuración de cron jobs
├── config.php            # Configuración del sistema
├── instalar.php          # Script de instalación
├── monitor.php           # Script de monitoreo
├── logs/                 # Directorio de logs
│   ├── auto_update.log   # Log de actualizaciones
│   ├── cron.log         # Log de cron jobs
│   ├── health_check.log # Log de verificación de salud
│   └── estadisticas.json # Estadísticas del catálogo
├── cache/                # Directorio de cache (futuro)
└── backups/              # Directorio de respaldos (futuro)
```

## 🛠️ Instalación

### Instalación Automática
```bash
# Ejecutar desde el servidor
php instalar.php

# O desde el navegador
https://stock.crusardi.net/catalogo_publico/instalar.php?install=true
```

### Instalación Manual

1. **Verificar archivos necesarios**
   ```bash
   ls -la index.php
   ls -la actualizar.php
   ls -la cron.php
   ls -la config.php
   ```

2. **Crear directorios necesarios**
   ```bash
   mkdir -p logs cache backups
   chmod 755 logs cache backups
   ```

3. **Configurar cron job**
   ```bash
   # Agregar al crontab
   crontab -e
   
   # Agregar estas líneas:
   0 */6 * * * /usr/bin/php /ruta/completa/catalogo_publico/actualizar.php >> /ruta/completa/catalogo_publico/logs/cron.log 2>&1
   0 2 * * 0 find /ruta/completa/catalogo_publico/logs -name "*.log" -mtime +30 -delete
   0 * * * * curl -s -o /dev/null -w "%{http_code}" https://stock.crusardi.net/catalogo_publico/ | grep -q "200" || echo "Catálogo no responde" >> /ruta/completa/catalogo_publico/logs/health_check.log
   ```

## 🔧 Configuración

### Configuración Básica
Editar `config.php`:

```php
// URLs y enlaces
define('CATALOGO_PUBLICO_URL', 'https://stock.crusardi.net/catalogo_publico/');
define('IMAGENES_BASE_URL', 'https://imagenes.crusardi.net/boconcept/STOCKCOMERCIAL/');

// Contacto
define('WHATSAPP_NUMBER', '573001234567');
define('EMAIL_CONTACTO', 'ventas@crusardi.net');

// Precios
define('PRECIO_CONSULTA_MIN', 999999);
define('DESCUENTO_MINIMO_DISPLAY', 5);
```

### Configuración de Notificaciones
```php
$NOTIFICATION_CONFIG = [
    'email_enabled' => true,
    'email_to' => 'tecnologia@crusardi.net',
    'email_from' => 'sistema@crusardi.net',
    'whatsapp_enabled' => false
];
```

## 📊 Monitoreo

### Verificar Estado del Sistema
```bash
# Monitoreo básico
php monitor.php

# Ver logs en tiempo real
tail -f logs/auto_update.log

# Verificar cron jobs
crontab -l
```

### URLs de Monitoreo
- **Estado del sistema**: `https://stock.crusardi.net/catalogo_publico/cron.php?action=status`
- **Prueba de actualización**: `https://stock.crusardi.net/catalogo_publico/cron.php?action=test`
- **Catálogo público**: `https://stock.crusardi.net/catalogo_publico/`

## 🔄 Actualización Automática

### Frecuencia
- **Cada 6 horas**: 00:00, 06:00, 12:00, 18:00
- **Limpieza de logs**: Domingos a las 2:00 AM
- **Verificación de salud**: Cada hora

### Proceso de Actualización
1. Ejecuta `consolidar_stock_crusardi()`
2. Verifica datos en `stock_calculado_cache`
3. Actualiza timestamp de última actualización
4. Genera estadísticas del catálogo
5. Verifica accesibilidad del catálogo público
6. Envía notificación por email (opcional)

### Logs de Actualización
```bash
# Ver último log
tail -20 logs/auto_update.log

# Buscar errores
grep "ERROR" logs/auto_update.log

# Ver estadísticas
cat logs/estadisticas.json
```

## 🎨 Personalización

### Estilos CSS
El catálogo usa CSS personalizado que se puede modificar en `index.php`:

```css
/* Colores principales */
.campaign-header { background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%); }
.contact-button { background-color: #4f46e5; }
.price-new.sale { color: #d53f40; }
```

### Filtros Personalizados
Agregar nuevos filtros en `config.php`:

```php
$CATEGORIAS_DISPONIBLES = [
    'living' => 'Living',
    'dormitorio' => 'Dormitorio',
    'nueva_categoria' => 'Nueva Categoría'
];
```

## 🚨 Solución de Problemas

### Problemas Comunes

1. **Catálogo no se actualiza**
   ```bash
   # Verificar cron job
   crontab -l
   
   # Ejecutar actualización manual
   php actualizar.php
   ```

2. **Error de permisos**
   ```bash
   chmod 755 logs cache backups
   chown www-data:www-data logs cache backups
   ```

3. **Error de base de datos**
   ```bash
   # Verificar conexión
   php -r "require_once 'config.php'; echo 'OK';"
   ```

4. **Imágenes no cargan**
   - Verificar URL en `IMAGENES_BASE_URL`
   - Comprobar que las imágenes existan en el servidor

### Logs de Debug
```bash
# Habilitar debug en config.php
$LOG_CONFIG['level'] = 'DEBUG';

# Ver logs detallados
tail -f logs/*.log
```

## 📈 Estadísticas

### Métricas Disponibles
- Total de productos disponibles
- Total de unidades en stock
- Número de kits vs artículos
- Productos imperfectos (oportunidades)
- Precio promedio, mínimo y máximo
- Última actualización

### Acceso a Estadísticas
```php
// Desde PHP
$stats = getCatalogStats($pdo);

// Desde archivo JSON
$stats = json_decode(file_get_contents('logs/estadisticas.json'), true);
```

## 🔒 Seguridad

### Medidas Implementadas
- Validación de parámetros de entrada
- Sanitización de datos de salida
- Protección contra inyección SQL
- Headers de seguridad HTTP
- Validación de tipos de archivo

### Recomendaciones
- Mantener actualizado el sistema
- Revisar logs regularmente
- Hacer respaldos de configuración
- Monitorear accesos al sistema

## 📞 Soporte

### Contacto Técnico
- **Email**: tecnologia@crusardi.net
- **Sistema**: stock.crusardi.net

### Documentación Adicional
- Logs del sistema: `logs/`
- Configuración: `config.php`
- Monitoreo: `monitor.php`

---

**Versión**: 1.0.0  
**Última actualización**: <?php echo date('Y-m-d'); ?>  
**Desarrollado por**: Equipo de Tecnología Crusardi
