<?php
// pages/actions/stock_calculado_export.php

// Cargar la configuración de la base de datos y las funciones
require_once '/home/crusardi/config_crusardi/database.php';
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../stock_calculado_functions.php';

try {
    // Generar la lista completa de todas las combinaciones posibles
    $generationResult = generate_combinations($pdo);
    $allCombinations = $generationResult['combinations'];
    
    $items_to_export = [];
    $filename = 'stock_report_'.date('Y-m-d').'.csv';

    // Determinar si se exportan todos los filtrados o solo los seleccionados
    if (isset($_POST['export_mode']) && $_POST['export_mode'] === 'all_filtered') {
        // Filtrar la lista completa usando los parámetros del formulario
        $items_to_export = filter_and_sort($allCombinations, $_POST);
        $filename = 'stock_filtrado_'.date('Y-m-d').'.csv';
    } elseif (!empty($_POST['selected_ids'])) {
        $selected_ids = $_POST['selected_ids'];
        // Filtrar la lista completa para encontrar solo los IDs seleccionados
        $items_to_export = array_filter($allCombinations, fn($combo) => in_array($combo['id'], $selected_ids));
        $filename = 'stock_seleccionado_'.date('Y-m-d').'.csv';
    }

    if (!empty($items_to_export)) {
        // Configurar las cabeceras para forzar la descarga del archivo CSV
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="'.$filename.'"');
        
        // Abrir el flujo de salida de PHP para escribir el CSV
        $output = fopen('php://output', 'w');
        
        // Escribir la fila de encabezado
        fputcsv($output, [
            'Referencia', 'Nombre', 'Tipo', 'Cantidad', 'Tienda', 'Ubicacion', 
            'Precio Antes', 'Descuento (%)', 'Precio Final', 'URL Imagen', 'Categoria'
        ]);
        
        // Escribir los datos de cada producto
        foreach ($items_to_export as $item) {
            fputcsv($output, [
                $item['lmat'] ?? '',
                $item['nombre'] ?? '',
                $item['type'] ?? '',
                $item['units'] ?? 0,
                $item['bodega'] ?? '',
                $item['almacen'] ?? '',
                $item['precio'] ?? 0,
                $item['descuento'] ?? 0,
                $item['precio_final'] ?? 0,
                $item['url_imagen'] ?? '',
                $item['categoria'] ?? ''
            ]);
        }
        
        fclose($output);
    } else {
        // Si no hay nada que exportar, redirigir con un mensaje de error (opcional)
        $_SESSION['upload_error'] = "No se encontraron items para exportar.";
        header('Location: ../../index.php?page=stock_calculado');
    }

} catch (Exception $e) {
    // En caso de un error grave, mostrar un mensaje
    die("Error al generar la exportación: " . $e->getMessage());
}
exit;