<?php
// pages/actions/relaciones_export.php
// Este script solo maneja la lógica de exportación de CSV para las relaciones.

// La variable $pdo y la sesión del usuario ya están disponibles desde index.php

$current_role = $_SESSION['user_role'] ?? 'viewer';
if ($current_role === 'viewer') {
    http_response_code(403); // Forbidden
    die("Acceso denegado. No tienes permisos para exportar.");
}

try {
    header('Content-Type: text/csv; charset=utf-8');
    $filename = $_GET['action'] === 'export_selected' ? 'relaciones_seleccionadas.csv' : 'relaciones_lmat.csv';
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Lmat', 'Parte', 'Ctd_requerida']);
    
    $sql = "SELECT lmat, parte, qty_required FROM lmat_relations";
    $params = [];
    
    if ($_GET['action'] === 'export_selected' && isset($_GET['selected_lmats']) && is_array($_GET['selected_lmats'])) {
        $selected_lmats = $_GET['selected_lmats'];
        if (!empty($selected_lmats)) {
            $placeholders = implode(',', array_fill(0, count($selected_lmats), '?'));
            $sql .= " WHERE lmat IN ($placeholders)";
            $params = $selected_lmats;
        }
    }
    
    $sql .= " ORDER BY lmat, parte";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    
    while ($row = $stmt->fetch()) {
        fputcsv($output, [$row['lmat'], $row['parte'], $row['qty_required']]);
    }
    
    fclose($output);

} catch (PDOException $e) {
    // Si hay un error de base de datos, lo notificamos de forma segura.
    header('Content-Type: text/plain');
    http_response_code(500); // Internal Server Error
    die("Error de base de datos al generar la exportación: " . $e->getMessage());
}
?>